uniform sampler2D 	tex;
uniform sampler2D	vel;

varying vec2		texcoord;

void main()
{
	vec2 v=texture2D(vel, texcoord).gb;
	vec4 color=texture2D(tex, texcoord);
	texcoord+=vel;
	
	for(int i = 1; i < 8; i++)
	{
 		// Sample the color buffer along the velocity vector.
 		vec4 currentColor = texture2D(tex, texcoord);

 		// Add the current color to our color sum.
		color += currentColor;
		texcoord += v;
	}

	gl_FragColor = color/8.0;
}
